/*
 * Decompiled with CFR 0.152.
 */
package OreSpawn.entities;

import OreSpawn.OreSpawnMain;
import dangerzone.Player;
import dangerzone.Utils;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityLiving;
import dangerzone.items.Items;
import dangerzone.rendering.TextureMapper;
import dangerzone.world.World;
import slick.Texture;

public class Cassowary
extends EntityLiving {
    public Cassowary(World w) {
        super(w);
        this.maxrenderdist = 130;
        this.height = 1.9f;
        this.width = 0.8f;
        this.uniquename = "OreSpawn:Cassowary";
        this.moveSpeed = 0.32f;
        this.setMaxHealth(10.0f);
        this.setHealth(10.0f);
        this.setDefense(1.0f);
        this.setAttackDamage(0.0f);
        this.movefrequency = 30;
        this.setExperience(5);
        this.canSwim = true;
        this.enable_avoid = true;
        this.avoiddistance = 25;
        this.daytimespawn = true;
        this.nighttimespawn = false;
        this.daytimedespawn = true;
        this.nighttimedespawn = true;
        this.enableBreeding(10);
        this.findbuddydistance = 16;
        this.findbuddyfrequency = 8;
    }

    public void doEntityAction(float deltaT) {
        this.enable_buddy = this.enable_buddy_nearest = this.isBaby();
        super.doEntityAction(deltaT);
    }

    public boolean isBuddy(Entity e) {
        return e instanceof Cassowary && !e.isBaby();
    }

    public boolean isFoodItem(int iid) {
        return iid == Items.apple.itemID;
    }

    public boolean isBreedingFoodForMe(int bid, int iid) {
        if (iid == OreSpawnMain.crystalapple.itemID) {
            return true;
        }
        return this.isFoodForMe(bid, iid);
    }

    public void update(float deltaT) {
        if (this.world.isServer && this.world.rand.nextInt(5000) == 1) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.eggcassowary.itemID, (float)0.1f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        super.update(deltaT);
    }

    public boolean shouldAvoidEntity(Entity e) {
        return e instanceof Player;
    }

    public String getLivingSound() {
        return null;
    }

    public String getHurtSound() {
        return "OreSpawn:duck_hurt";
    }

    public String getDeathSound() {
        return "OreSpawn:duck_hurt";
    }

    public void doDeathDrops() {
        int howmany = 1 + this.world.rand.nextInt(3);
        int i = 0;
        while (i < howmany) {
            Utils.doDropRand((World)this.world, (int)0, (int)Items.ostrichmeat.itemID, (float)2.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            ++i;
        }
        if (this.world.rand.nextInt(10) == 1) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.trophycassowary.itemID, (float)1.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        super.doDeathDrops();
    }

    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture((String)"orespawnres/skins/Cassowarytexture.png");
        }
        return this.texture;
    }
}

